--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A controller for audio. It holds data on the status of the current and next music tracks, volume settings and other related facilities. All the volumes are expressed in range [0, 1].
--- @class tes3audioController
--- @field audioFlags number A bit set for audio flags.
--- @field currentMusicFilePath string File path of the currently playing music track. The path can not be longer than 260 characters.
--- @field directSoundInitFailed boolean A flag marking if the DirectSound initialization failed. Part of the audio flags.
--- @field disableAudio boolean A flag which controls whether the audio is disabled or not.
--- @field dsound3DChanged boolean A flag marking if the direct 3D sound has changed.
--- @field dsound3DCommitted boolean A flag marking if the direct 3D sound has been committed.
--- @field hasStaticBuffers boolean A flag marking if there are static audio buffers. Part of the audio flags.
--- @field hasStreamingBuffers boolean A flag marking if there are streaming audio buffers. Part of the audio flags.
--- @field isFilterGraphValid boolean A flag marking if the music filter graph is valid. Part of the music flags.
--- @field isMusicPaused boolean A flag marking if music is paused. Part of the music flags.
--- @field isMusicPlaying boolean A flag marking if music is playing. Part of the music flags.
--- @field listenerPosition tes3vector3 The sound listener position.
--- @field musicDuration number *Read-only*. The duration of the currently playing music track.
--- @field musicFadeBeginTimestamp number The timestamp at which currently playing music track started fading in. So, it's a timestamp at which currently playing music track started.
--- @field musicFlags number A bit set for music flags.
--- @field musicNextTrackStartTimestamp number The timestamp at which next track will start playing.
--- @field musicNextTrackVolume number The volume of the next track.
--- @field musicPosition number Current play time for currently playing music track.
--- @field nextMusicFilePath string File path of the music track which is to be played next. The path can not be longer than 260 characters.
--- @field pitchAxis number Approximated pitch axis in radians.
--- @field volumeEffects number Volume of the effects. Corresponds to the effects volume slider in Audio settings.
--- @field volumeFootsteps number Volume of the footsteps. Corresponds to the footsteps volume slider in Audio settings.
--- @field volumeMaster number Master volume. Corresponds to the master volume slider in Audio settings.
--- @field volumeMusic number Volume of the music. Corresponds to the music volume slider in Audio settings.
--- @field volumeVoice number Volume of the voices. Corresponds to the voice volume slider in Audio settings.
--- @field yawAxis number Approximated yaw axis in radians.
tes3audioController = {}

--- Changes currently playing music track according to provided parameters.
--- @param filename string File name of the new music track.
--- @param crossfade? number *Default*: `1000`. Duration of the crossfading between music tracks. Measured in miliseconds.
--- @param volume? number *Default*: `1`. Allows changing the volume of the music track.
function tes3audioController:changeMusicTrack(filename, crossfade, volume) end

--- Final volume of a provided type of audio, after master volume and its own volume adjustments. Music volume is an exception since it isn't affected by master volume.
--- @param mix tes3.soundMix The type of sound mix to perform a check for. Accepts values from [`tes3.soundMix`](https://mwse.github.io/MWSE/references/sound-mix-types/) namespace.
--- @return number volume No description yet available.
function tes3audioController:getMixVolume(mix) end

--- Loads a music file and determines its duration, in seconds.
--- @param path string The path to the music track, relative to the game installation directory.
--- @return number duration The number of seconds of the track, in seconds.
function tes3audioController:getMusicFileDuration(path) end

--- Pauses the game's music.
function tes3audioController:pauseMusic() end

--- Unpauses the game's music.
function tes3audioController:unpauseMusic() end

